﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication.Accounts
{
    public partial class Administration : BaseComponent
    {
        protected abstract class AdminPanel
        {
            public enum EditModeType
            {
                NotLoaded = -1,
                None = 0,
                EditOrInsert = 1,
                Remove = 2,
                GenerateCertificate = 3,
            }

            private Administration _Component = null;

            protected Administration Component
            {
                get
                {
                    return _Component;
                }
            }

            public AdminPanel(Administration BaseComponent)
            {
                _Component = BaseComponent;
            }

            public abstract void Load();
            public abstract bool Save();

            private EditModeType _editMode = EditModeType.NotLoaded;
            protected EditModeType EditMode
            {
                get
                {
                    if (_editMode == EditModeType.NotLoaded)
                    {
                        _editMode = EditModeType.None;
                        try
                        {
                            _editMode = (EditModeType)Component.Environment.GetRequestParamInt("editmode");
                        }
                        catch { }
                    }
                    return _editMode;
                }
            }

            private long? _studentID = null;
            protected long? StudentID
            {
                get
                {
                    if (!_studentID.HasValue)
                    {
                        string _studentIDString = Component.Environment.GetRequestParamString("studentid");
                        if (!string.IsNullOrEmpty(_studentIDString))
                        {
                            long _id = 0;
                            if (long.TryParse(_studentIDString, out _id))
                            {
                                _studentID = _id;
                            }
                        }
                    }
                    return _studentID;
                }
            }

            private long? _classID = null;
            protected long? ClassID
            {
                get
                {
                    if (!_classID.HasValue)
                    {
                        string _classIDString = Component.Environment.GetRequestParamString("classid");
                        if (!string.IsNullOrEmpty(_classIDString))
                        {
                            long _id = 0;
                            if (long.TryParse(_classIDString, out _id))
                            {
                                _classID = _id;
                            }
                        }
                    }
                    return _classID;
                }
            }
        }
    }
}
